import math
from typing import List

def matrix_product(A: List[List[int]], B: List[List[int]]) -> List[List[int]]:
    """Return the product of two 2x2 matrices A and B."""
    output = [[0, 0], [0, 0]]
    output[0][0] = A[0][0] * B[0][0] + A[0][1] * B[1][0]
    output[0][1] = A[0][0] * B[0][1] + A[0][1] * B[1][1]
    output[1][0] = A[1][0] * B[0][0] + A[1][1] * B[1][0]
    output[1][1] = A[1][0] * B[0][1] + A[1][1] * B[1][1]
    return output

def matrix_vector_product(A: List[List[int]], v: List[int]) -> List[int]:
    """Return the product of a 2x2 matrix A and a 2D vector v."""
    output = [0, 0]
    output[0] = A[0][0] * v[0] + A[0][1] * v[1]
    output[1] = A[1][0] * v[0] + A[1][1] * v[1]
    return output

if __name__ == "__main__":
    vector_start = list(map(int, input().strip().split()))
    vector_end = list(map(int, input().strip().split()))
    angles = [int(input()) for _ in range(int(input()))]

    angle = math.radians(sum(angles))
    rotation_matrix = [
        [math.cos(angle), -math.sin(angle)],
        [math.sin(angle), math.cos(angle)]
    ]

    vector_start_rotated = matrix_vector_product(rotation_matrix, vector_start)
    vector_end_rotated = matrix_vector_product(rotation_matrix, vector_end)
    answer = sum(vector_start_rotated + vector_end_rotated)

    answer = round(answer, 4)
    print(answer)